/** @file   consts.cpp
 * @brief   Constant definitions
 * @version $Revision: 1.6 $
 * @date    $Date: 2006/08/13 10:34:56 $
 * @author  Tomi Lamminsaari
 */
 
#include "consts.h"
#include <allegro.h>
#include <fstream>
#include "utils.h"
using std::string;
using std::vector;
using namespace eng2d;


namespace WeWantWar {

const float Consts::GRAVITY = 0.12;
const int Consts::MAX_BULLETTIME;
const float Consts::CROSSHAIR_DISTANCE = -140;
const float Consts::SNIPERMODE_RANGE_FACTOR = 2.5;
const bool Consts::CHECK_HASH_CODES;

const string Consts::VERSION_STR( "version 0.85" );
const float Consts::VERSION_NUMBER = 0.75;
const string Consts::HIGHSCOREFILE_NAME("data/highscores.txt");
const string Consts::TMPFILE_PLAYERDATA("data/tmp_1.dat");

vector<string> Consts::saveSlotFiles;

void Consts::init()
{
  initSaveSlots();
}

void Consts::initSaveSlots()
{
  saveSlotFiles.push_back("data/save_1.txt");
  saveSlotFiles.push_back("data/save_2.txt");
  saveSlotFiles.push_back("data/save_3.txt");
  saveSlotFiles.push_back("data/save_4.txt");
  saveSlotFiles.push_back("data/save_5.txt");
  saveSlotFiles.push_back("data/save_6.txt");
}

} // end of namespace

/**
 * Version history
 * ===============
 * $Log: consts.cpp,v $
 * Revision 1.6  2006/08/13 10:34:56  lamminsa
 * Version number increased to 0.85.
 *
 * Revision 1.5  2006/08/06 21:37:01  lamminsa
 * Version number updated.
 *
 * Revision 1.4  2006/06/03 15:52:07  lamminsa
 * Version number changed to 0.75
 *
 * Revision 1.3  2006/04/03 21:00:49  lamminsa
 * Version string changed.
 *
 * Revision 1.2  2006/03/16 21:12:44  lamminsa
 * Code cleanup.
 *
 * Revision 1.1.1.1  2006/01/21 23:02:43  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:15:32+02  lamminsa
 * Initial revision
 *
 */
